// Video Editing Courses - Version 4 (HTML/CSS/JS) - Tech Style

let currentSlide = 0
let slides = []
let dots = []
let slideInterval
let selectedSoftware = ''
let projects = []

function initPage() {
  const currentPage = window.location.pathname.includes('enroll.html') ? 'enroll' : 'index'
  
  if (currentPage === 'enroll') {
    initEnrollPage()
  } else {
    initIndexPage()
  }
  
  initSlider()
}

function initIndexPage() {
  loadProjects()
  updateStats()
  
  setInterval(() => {
    loadProjects()
    updateStats()
  }, 500)
}

function loadProjects() {
  const saved = localStorage.getItem('videoProjects')
  
  if (saved) {
    try {
      projects = JSON.parse(saved)
    } catch (e) {
      projects = []
    }
  } else {
    projects = [
      {
        id: 1,
        course: 'Premiere Pro: Продвинутый уровень',
        instructor: 'Алексей Кинематографов',
        work: 'Короткометражный фильм "Городские ритмы"',
        rating: 5,
        photo: 'images/project-1.jpg'
      },
      {
        id: 2,
        course: 'DaVinci Resolve: Цветокоррекция',
        instructor: 'Мария Режиссерова',
        work: 'Музыкальный клип "Неоновые ночи"',
        rating: 4,
        photo: 'images/project-2.jpg'
      },
      {
        id: 3,
        course: 'Final Cut Pro: Монтаж для YouTube',
        instructor: 'Дмитрий Видеографов',
        work: 'Влог-серия "Путешествия"',
        rating: 5,
        photo: 'images/project-3.jpg'
      }
    ]
    localStorage.setItem('videoProjects', JSON.stringify(projects))
  }
  
  renderProjects()
}

function renderProjects() {
  const container = document.getElementById('projects-stack')
  if (!container) return
  
  if (projects.length === 0) {
    container.innerHTML = `
      <div class="empty-state-tech">
        <div class="empty-icon-container-tech">
          <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
            <polygon points="5 3 19 12 5 21 5 3"/>
          </svg>
          <div class="empty-pulse-tech"></div>
        </div>
        <h2 class="empty-title-tech">Нет проектов</h2>
        <p class="empty-text-tech">Начните с записи на первый курс</p>
        <a href="enroll.html" class="empty-button-tech">Записаться</a>
      </div>
    `
    return
  }
  
  container.innerHTML = projects.map((project, index) => {
    return `
      <div class="project-card-tech" style="z-index: ${projects.length - index}">
        <div class="project-image-tech">
          <img src="${project.photo}" alt="${project.work}">
          <div class="project-overlay-tech">
            <button class="play-button-tech">
              <svg width="28" height="28" viewBox="0 0 24 24" fill="currentColor" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round">
                <polygon points="5 3 19 12 5 21 5 3"/>
              </svg>
            </button>
          </div>
          <div class="project-rating-tech">
            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <span>${project.rating}/5</span>
          </div>
          <div class="project-gradient-tech"></div>
        </div>
        
        <div class="project-info-tech">
          <h3 class="project-title-tech">${project.course}</h3>
          <div class="project-meta-tech">
            <div class="meta-item-tech">
              <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                <circle cx="12" cy="7" r="4"/>
              </svg>
              <span>${project.instructor}</span>
            </div>
            <div class="meta-item-tech">
              <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <polygon points="5 3 19 12 5 21 5 3"/>
              </svg>
              <span>${project.work}</span>
            </div>
          </div>
        </div>
      </div>
    `
  }).join('')
}

function updateStats() {
  const statProjects = document.getElementById('stat-projects')
  const statRating = document.getElementById('stat-rating')
  
  if (statProjects) {
    statProjects.textContent = projects.length
  }
  
  if (statRating) {
    const avgRating = projects.length > 0 
      ? (projects.reduce((sum, p) => sum + (p.rating || 0), 0) / projects.length).toFixed(1)
      : '0.0'
    statRating.textContent = avgRating
  }
}

function initEnrollPage() {
  const softwareItems = document.querySelectorAll('.software-item-tech')
  const dateGroup = document.getElementById('date-group')
  const submitBtn = document.getElementById('submit-btn')
  const form = document.getElementById('enroll-form')
  const successMessage = document.getElementById('success-message')
  
  softwareItems.forEach(item => {
    item.addEventListener('click', () => {
      softwareItems.forEach(i => i.classList.remove('selected'))
      item.classList.add('selected')
      selectedSoftware = item.dataset.software
      
      const color = item.dataset.color
      if (color) {
        item.style.borderLeftColor = color
      }
      
      if (dateGroup) {
        dateGroup.style.display = 'flex'
      }
      
      if (submitBtn) {
        submitBtn.disabled = !selectedSoftware || !document.getElementById('start-date')?.value
      }
    })
  })
  
  const dateInput = document.getElementById('start-date')
  if (dateInput) {
    const today = new Date()
    const maxDate = new Date(today.getTime() + 180 * 24 * 60 * 60 * 1000)
    dateInput.min = today.toISOString().split('T')[0]
    dateInput.max = maxDate.toISOString().split('T')[0]
    
    dateInput.addEventListener('change', () => {
      if (submitBtn) {
        submitBtn.disabled = !selectedSoftware || !dateInput.value
      }
    })
  }
  
  if (form) {
    form.addEventListener('submit', (e) => {
      e.preventDefault()
      
      if (!selectedSoftware || !dateInput?.value) return
      
      const saved = localStorage.getItem('videoProjects')
      const projects = saved ? JSON.parse(saved) : []
      
      const softwareNames = {
        premiere: 'Premiere Pro',
        davinci: 'DaVinci Resolve',
        finalcut: 'Final Cut',
        capcut: 'CapCut'
      }
      
      const newProject = {
        id: Date.now(),
        course: `${softwareNames[selectedSoftware]}: Базовый курс`,
        instructor: 'Преподаватель будет назначен',
        work: 'Первый проект',
        rating: null,
        photo: 'images/project-placeholder.jpg'
      }
      
      projects.push(newProject)
      localStorage.setItem('videoProjects', JSON.stringify(projects))
      
      if (successMessage) {
        successMessage.style.display = 'flex'
      }
      
      setTimeout(() => {
        window.location.href = 'index.html'
      }, 2000)
    })
  }
}

function initSlider() {
  slides = Array.from(document.querySelectorAll('.slide-tech'))
  dots = Array.from(document.querySelectorAll('.dot-tech'))
  
  if (slides.length === 0) return
  
  const prevBtn = document.querySelector('.slider-btn-prev-tech')
  const nextBtn = document.querySelector('.slider-btn-next-tech')
  
  if (prevBtn) {
    prevBtn.addEventListener('click', () => {
      currentSlide = (currentSlide - 1 + slides.length) % slides.length
      updateSlider()
    })
  }
  
  if (nextBtn) {
    nextBtn.addEventListener('click', () => {
      currentSlide = (currentSlide + 1) % slides.length
      updateSlider()
    })
  }
  
  dots.forEach((dot, index) => {
    dot.addEventListener('click', () => {
      currentSlide = index
      updateSlider()
    })
  })
  
  function updateSlider() {
    slides.forEach((slide, index) => {
      slide.classList.toggle('active', index === currentSlide)
    })
    
    dots.forEach((dot, index) => {
      dot.classList.toggle('active', index === currentSlide)
    })
  }
  
  slideInterval = setInterval(() => {
    currentSlide = (currentSlide + 1) % slides.length
    updateSlider()
  }, 3000)
}

document.addEventListener('DOMContentLoaded', initPage)

